	function [ZPR] = ZEROAMW(h, wT)
	
	% Evaluates the zero-phase response of a linear-phase 
	% FIR filter with impulse response h at angular frequencies wT
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 			Tapio Saramaki 17.11.1997
	%	Modified by:	
	%	Copyright:			by authors - not released for commercial use
	%	Version:			1	 
	%	Known bugs:	 
	%	Report bugs to:		tapio.saramaki@tut.fi
	
	N = length(h);
	NN = floor((N-1)/2);
	iodd = 0;
	if 2*round(N/2) == N iodd = 1; end
	isy = 1;
	sum1 = sum(h(1:NN));
	sum2 = sum(h(N+1-NN:N));
	if abs(sum2-sum1)/abs(sum1) < 0.5 isy = 0; end
	if iodd == 0 & isy == 0 itype = 1;end
	if iodd == 1 & isy == 0 itype = 2;end
	if iodd == 0 & isy == 1 itype = 3;end
	if iodd == 1 & isy == 1 itype = 4;end
	L = floor((N+2)/2);
	ZPR = zeros(size(wT));
	if itype == 1, ZPR = ZPR+h(L);end
	for k = 1:L-1
		if itype == 1
			ZPR = ZPR+2*h(L-k)*cos(k*wT);
		end
		if itype == 2
			ZPR = ZPR+2*h(L-k)*cos((k-0.5)*wT);
		end
		if itype == 3
			ZPR = ZPR+2*h(L-k)*sin(k*wT);
		end
		if itype == 4
			ZPR = ZPR+2*h(L-k)*sin((k-0.5)*wT);
		end
	end
		
